/* Licensed under BSD without advertising clause. (c) 2006 Nicholas J. Kain */

#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

static volatile int pending_exit;
static int delay;

static void sighandler(int sig) {
	pending_exit = 1;
}

static void fix_signals(void) {
	struct sigaction new_action;
	sigset_t set;
	
	sigfillset(&set);
	sigdelset(&set, SIGTERM);
	sigprocmask(SIG_BLOCK, &set, NULL);
	new_action.sa_handler = sighandler;
	sigemptyset(&new_action.sa_mask);
	new_action.sa_flags = 0;
	(void)sigaction(SIGTERM, &new_action, NULL);
}

int main(int argc, char** argv) {
	int fd, valid = 0, i;
	char *p;
	
	/* I don't want to include getopt. */
	for (i=1; i < argc; ++i) {
		p = argv[i];
		while (p && *p) {
			if (delay != 0)
				break;
		    switch (*p) {
				case '-':
					valid = 1;
					break;
		        case 't':
					if (valid == 1)
						valid = 2;
		            break;
				default:
					if (valid == 2)
						delay = atoi(p);
					valid = 0;
					break;
			}
			++p;
		}
	}

	if (delay == 0) {
		printf("simple watchdog daemon, copyright (c) 2006 Nicholas Kain\nUsage: watchdog -t <delay>\n\ndelay: n seconds between writes\n");
		exit(EXIT_FAILURE);
	}

	fix_signals();
	fd = open("/dev/watchdog", O_WRONLY);
	if (fd == -1) {
		perror("can't open /dev/watchdog");
		exit(EXIT_FAILURE);
	}
	daemon(0,0);

	for(;;) {
		if (pending_exit)
			break;
		write(fd, "a", 1);
		sleep(delay);
	}

	write(fd, "V", 1);
	close(fd);
	exit(EXIT_FAILURE);
}

