let tm26 x =
    if x > 25 then x - 26 else x

let translate_lc c =
    let x = int_of_char c in
    let n = x - 97 in
    char_of_int (tm26 (n + 13) + 97)

let translate_uc c =
    let x = int_of_char c in
    let n = x - 65 in
    char_of_int (tm26 (n + 13) + 65)

let filter_char c = 
    let x = int_of_char c in
    match x with
        x when x > 64 && x < 91 -> translate_uc c
    |   x when x > 96 && x < 123 -> translate_lc c
    |   _ -> c

let translate_str str = 
    let len = String.length str in
    let dest = String.create len in
    if len = 0 then "" else
        begin
            for i = 0 to len - 1 do
                dest.[i] <- filter_char str.[i]
            done;
            dest
        end

let read_in =
    try
        while true do
            let ol = translate_str (input_line stdin) in
            output stdout ol 0 (String.length ol) ;
            output stdout "\n" 0 1
        done;
    with End_of_file -> flush stdout

