/*
RSD PTR: Checksum=24, OEMID=Nvidia, RsdtAddress=0x3fff3000
 */
/*
RSDT: Length=44, Revision=1, Checksum=209,
	OEMID=Nvidia, OEM Table ID=AWRDACPI, OEM Revision=0x42302e31,
	Creator ID=AWRD, Creator Revision=0x0
 */
/*
	Entries={ 0x3fff3040, 0x3fff74c0 }
 */
/*
	DSDT=0x3fff30c0
	INT_MODEL=APIC
	SCI_INT=9
	SMI_CMD=0x442e, ACPI_ENABLE=0xa1, ACPI_DISABLE=0xa0, S4BIOS_REQ=0x0
	PM1a_EVT_BLK=0x4000-0x4003
	PM1a_CNT_BLK=0x4004-0x4005
	PM2_TMR_BLK=0x4008-0x400b
	PM2_GPE0_BLK=0x4020-0x4027
	PM2_GPE1_BLK=0x44a0-0x44af, GPE1_BASE=32
	P_LVL2_LAT=101ms, P_LVL3_LAT=1001ms
	FLUSH_SIZE=0, FLUSH_STRIDE=0
	DUTY_OFFSET=1, DUTY_WIDTH=0
	DAY_ALRM=125, MON_ALRM=126, CENTURY=50
	Flags={WBINVD,PROC_C1,SLP_BUTTON,RTC_S4}
 */
/*
DSDT: Length=17383, Revision=1, Checksum=178,
	OEMID=NVIDIA, OEM Table ID=AWRDACPI, OEM Revision=0x1000,
	Creator ID=MSFT, Creator Revision=0x100000e
 */
DefinitionBlock (
	"acpi_dsdt.aml",    //Output filename
	"DSDT",		        //Signature
	0x1,                //DSDT Revision
	"NVIDIA",			//OEMID
	"AWRDACPI",			//TABLE ID
	0x1000			    //OEM Revision
)

{
Scope(\_PR_) {
    Processor(\_PR_.CPU0, 0, 0x0, 0x0) {
    }
}
Name(\_S0_, Package(0x4) {
    0x0,
    0x0,
    0x0,
    0x0,
})
Name(\_S1_, Package(0x4) {
    0x1,
    0x1,
    0x0,
    0x0,
})
Name(\SS3_, Package(0x4) {
    0x5,
    0x5,
    0x0,
    0x0,
})
Name(\_S4_, Package(0x4) {
    0x6,
    0x6,
    0x0,
    0x0,
})
Name(\_S5_, Package(0x4) {
    0x7,
    0x7,
    0x0,
    0x0,
})
OperationRegion(\DEBG, SystemIO, 0x80, 0x1)
Field(\DEBG, ByteAcc, NoLock, Preserve) {
    DBG1,	8
}
OperationRegion(Z002, SystemIO, 0x21, 0x1)
Field(Z002, ByteAcc, NoLock, Preserve) {
    Z000,	8
}
OperationRegion(KBC_, SystemIO, 0x64, 0x1)
Field(KBC_, ByteAcc, NoLock, Preserve) {
    KCMD,	8
}
OperationRegion(EXTM, SystemMemory, 0x000ff830, 0x10)
Field(EXTM, WordAcc, NoLock, Preserve) {
    ROM1,	16,
    RMS1,	16,
    ROM2,	16,
    RMS2,	16,
    ROM3,	16,
    RMS3,	16,
    AMEM,	32
}
OperationRegion(\PM1S, SystemIO, 0x4000, 0x2)
Field(\PM1S, ByteAcc, NoLock, Preserve) {
    Offset(0x1),
    PBTS,	1,
    ,	1,
    RTCS,	1,
    ,	4,
    WAKS,	1
}
OperationRegion(ELCR, SystemIO, 0x04d0, 0x2)
Field(ELCR, ByteAcc, NoLock, Preserve) {
    ELC1,	8,
    ELC2,	8
}
OperationRegion(\STUS, SystemIO, 0x4400, 0x4)
Field(\STUS, ByteAcc, NoLock, Preserve) {
    G_ST,	32
}
OperationRegion(\SMIS, SystemIO, 0x4020, 0x4)
Field(\SMIS, ByteAcc, NoLock, Preserve) {
    P_20,	32
}
OperationRegion(\SMIC, SystemIO, 0x442e, 0x1)
Field(\SMIC, ByteAcc, NoLock, Preserve) {
    SCP_,	8
}
OperationRegion(\GP1_, SystemIO, 0x44c0, 0x32)
Field(\GP1_, ByteAcc, NoLock, Preserve) {
    GP00,	8,
    GP01,	8,
    GP02,	8,
    GP03,	8,
    GP04,	8,
    GP05,	8,
    GP06,	8,
    GP07,	8,
    GP08,	8,
    GP09,	8,
    GP10,	8,
    GP11,	8,
    GP12,	8,
    GP13,	8,
    GP14,	8,
    GP15,	8,
    GP16,	8,
    GP17,	8,
    GP18,	8,
    GP19,	8,
    GP20,	8,
    GP21,	8,
    GP22,	8,
    Offset(0x18),
    GP24,	8,
    GP25,	8,
    GP26,	8,
    GP27,	8,
    GP28,	8,
    GP29,	8,
    GP30,	8,
    GP31,	8,
    GP32,	8,
    GP33,	8,
    GP34,	8,
    GP35,	8,
    GP36,	8,
    GP37,	8,
    GP38,	8,
    GP39,	8,
    GP40,	8,
    GP41,	8,
    GP42,	8,
    GP43,	8,
    GP44,	8,
    GP45,	8,
    GP46,	8,
    GP47,	8,
    GP48,	8,
    GP49,	8
}
Name(OSFX, 0x1)
Name(OSFL, 0x1)
Method(STRC, 2) {
    If(LNot(LEqual(SizeOf(Arg0), SizeOf(Arg1)))) {
        Return(0x0)
    }
    Add(SizeOf(Arg0), 0x1, Local0)
    Name(BUF0, Buffer(Local0) { })
    Name(BUF1, Buffer(Local0) { })
    Store(Arg0, BUF0)
    Store(Arg1, BUF1)
    While(Local0) {
        Decrement(Local0)
        If(LNot(LEqual(DerefOf(Index(BUF0, Local0, )), DerefOf(Index(BUF1, Local0, ))))) {
            Return(Zero)
        }
    }
    Return(One)
}
OperationRegion(RTCM, SystemIO, 0x70, 0x2)
Field(RTCM, ByteAcc, NoLock, Preserve) {
    CMIN,	8,
    CMDA,	8
}
IndexField(CMIN, CMDA, ByteAcc, NoLock, Preserve) {
    Offset(0xf),
    SHUT,	8
}
OperationRegion(INFO, SystemMemory, 0x000ff840, 0x1)
Field(INFO, ByteAcc, NoLock, Preserve) {
    KBDI,	1,
    RTCW,	1,
    PS2F,	1,
    IRFL,	2,
    DISE,	1,
    SSHU,	1
}
OperationRegion(BEEP, SystemIO, 0x61, 0x1)
Field(BEEP, ByteAcc, NoLock, Preserve) {
    S1B_,	8
}
OperationRegion(CONT, SystemIO, 0x40, 0x4)
Field(CONT, ByteAcc, NoLock, Preserve) {
    CNT0,	8,
    CNT1,	8,
    CNT2,	8,
    CTRL,	8
}
Method(SPKR, 1) {
    Store(S1B_, Local0)
    Store(0xb6, CTRL)
    Store(0x55, CNT2)
    Store(0x3, CNT2)
    Store(Arg0, Local2)
    While(LGreater(Local2, 0x0)) {
        Or(S1B_, 0x3, S1B_)
        Store(0x5fff, Local3)
        While(LGreater(Local3, 0x0)) {
            Decrement(Local3)
        }
        And(S1B_, 0xfc, S1B_)
        Store(0x0eff, Local3)
        While(LGreater(Local3, 0x0)) {
            Decrement(Local3)
        }
        Decrement(Local2)
    }
    Store(Local0, S1B_)
}
Scope(\) {
    Name(PICF, 0x0)
    Method(_PIC, 1) {
        Store(Arg0, PICF)
    }
}
Name(SID4, 0x0)
Name(SLG0, 0x0)
Name(SLG1, 0x0)
Name(SLG2, 0x0)
Name(SLG3, 0x0)
Name(SLG4, 0x0)
Name(SLG5, 0x0)
Name(SLG6, 0x0)
Name(SLG7, 0x0)
Name(SLG8, 0x0)
Name(SLG9, 0x0)
Name(SLGA, 0x0)
Name(SID5, 0x0)
Name(SSM0, 0x0)
Name(SSM1, 0x0)
Name(SSM2, 0x0)
Name(SSM3, 0x0)
Name(SSM4, 0x0)
Name(SUA0, 0x0)
Name(SUB0, 0x0)
Name(SX__, 0x0)
Name(SFLG, 0x0)
Name(SID0, 0x0)
Name(SID1, 0x0)
Name(SID2, 0x0)
Name(SID3, 0x0)
Method(\_PTS, 1) {
    Store(Arg0, Local0)
    Store(Local0, SX__)
    Or(Arg0, 0xf0, Local0)
    Store(Local0, DBG1)
    OSTP()
    Store(\_SB_.PCI0.IDE0.ID20, SID0)
    Store(\_SB_.PCI0.IDE0.IDTS, SID1)
    Store(\_SB_.PCI0.IDE0.IDTP, SID2)
    Store(\_SB_.PCI0.IDE0.ID22, SID3)
    Store(\_SB_.PCI0.IDE0.UMSS, SID4)
    Store(\_SB_.PCI0.IDE0.UMSP, SID5)
    If(LEqual(Arg0, 0x1)) {
        Store(\_SB_.PCI0.CTL0, Local0)
        Or(Local0, 0x04000000, Local0)
        Store(Local0, \_SB_.PCI0.CTL0)
    }
    If(LEqual(Arg0, 0x3)) {
        Store(\_SB_.PCI0.CTL0, Local0)
        Or(Local0, 0x04000000, Local0)
        Store(Local0, \_SB_.PCI0.CTL0)
    }
    If(LEqual(Arg0, 0x5)) {
        If(LNot(LEqual(OSFL, 0x0))) {
            Sleep(0x01f4)
        }
    }
}
Method(\_WAK, 1) {
    Store(0xff, DBG1)
    Store(0x0, SFLG)
    If(LEqual(RTCW, 0x0)) {
        Notify(\_SB_.PWRB, 0x2)
    }
    Notify(\_SB_.PCI0.USB0, 0x0)
    Notify(\_SB_.PCI0.USB1, 0x0)
    Store(\_SB_.PCI0.CTL0, Local0)
    And(Local0, 0xfbffffff, Local0)
    Store(Local0, \_SB_.PCI0.CTL0)
    If(LNot(LLess(OSFL, 0x1))) {
        Store(0x0, \_SB_.PCI0.SMB0.SMPM)
        Store(0x5000, \_SB_.PCI0.SMB0.SB1_)
        Store(0x5500, \_SB_.PCI0.SMB0.SB2_)
    }
	Return(Package(0x02){0x00, 0x00})
}
Scope(\_SI_) {
    Method(_MSG, 1) {
        Store("==== MSG Working ====", Debug)
    }
    Method(_SST, 1) {
        Store("==== SST Working ====", Debug)
    }
}
Scope(\_GPE) {
    Method(_L00) {
        Notify(\_SB_.PCI0.HUB0, 0x2)
    }
    Method(_L03) {
        Notify(\_SB_.PCI0.UAR1, 0x2)
    }
    Method(_L0B) {
        Notify(\_SB_.PCI0.MMAC, 0x2)
    }
    Method(_L0D) {
        Notify(\_SB_.PCI0.USB0, 0x2)
    }
    Method(_L0C) {
        Notify(\_SB_.PCI0.USB1, 0x2)
    }
    Method(_L05) {
        Notify(\_SB_.PCI0.USB2, 0x2)
    }
    Method(_L0F) {
        Notify(\_SB_.PCI0.F139, 0x2)
    }
    Method(_L0A) {
        Notify(\_SB_.PCI0.HUB1, 0x2)
    }
    Method(_L07) {
        Notify(\_SB_.PCI0.MMCI, 0x2)
    }
}
Scope(\_SB_) {
    Device(PMIO) {
        Name(_HID, 0x020cd041)
        Name(_UID, 0x3)
        Method(_CRS) {
            Name(IODM, Buffer(0xa) {0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x79, 0x0 })
            Name(IORT, Buffer(0x32) {0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x79, 0x0 })
            CreateWordField(IORT, 0x2, I1MN)
            CreateWordField(IORT, 0x4, I1MX)
            CreateWordField(IORT, 0xa, I2MN)
            CreateWordField(IORT, 0xc, I2MX)
            CreateWordField(IORT, 0x12, I3MN)
            CreateWordField(IORT, 0x14, I3MX)
            CreateWordField(IORT, 0x1a, I4MN)
            CreateWordField(IORT, 0x1c, I4MX)
            CreateWordField(IORT, 0x22, I5MN)
            CreateWordField(IORT, 0x24, I5MX)
            CreateWordField(IORT, 0x2a, I6MN)
            CreateWordField(IORT, 0x2c, I6MX)
            And(PMBR, 0xfffc, I1MN)
            Store(I1MN, I1MX)
            Add(I1MN, 0x80, Local0)
            Store(Local0, I2MN)
            Store(Local0, I2MX)
            And(NVSB, 0xfffc, I3MN)
            Store(I3MN, I3MX)
            Add(I3MN, 0x80, Local0)
            Store(Local0, I4MN)
            Store(Local0, I4MX)
            And(ANLG, 0xfffc, I5MN)
            Store(I5MN, I5MX)
            Add(I5MN, 0x80, Local0)
            Store(Local0, I6MN)
            Store(Local0, I6MX)
            If(I1MN) {
                Store(IORT, Local0)
            }
            Else {
                Store(IODM, Local0)
            }
            Return(Local0)
        }
    }
    Device(SMIO) {
        Name(_HID, 0x020cd041)
        Name(_UID, 0x4)
        Name(_CRS, Buffer(0x12) {0x47, 0x1, 0x0, 0x50, 0x0, 0x50, 0x1, 0x40, 0x47, 0x1, 0x0, 0x55, 0x0, 0x55, 0x1, 0x40, 0x79, 0x0 })
    }
    Device(PWRB) {
        Name(_HID, 0x0c0cd041)
        Method(_STA) {
            Return(0xb)
        }
    }
    Device(MEM_) {
        Name(_HID, 0x010cd041)
        Method(_CRS) {
            Name(BUF0, Buffer(0x7a) {0x86, 0x9, 0x0, 0x1, 0x0, 0x0, 0xf, 0x0, 0x0, 0x40, 0x0, 0x0, 0x86, 0x9, 0x0, 0x1, 0x0, 0x40, 0xf, 0x0, 0x0, 0x40, 0x0, 0x0, 0x86, 0x9, 0x0, 0x1, 0x0, 0x80, 0xf, 0x0, 0x0, 0x40, 0x0, 0x0, 0x86, 0x9, 0x0, 0x1, 0x0, 0xc0, 0xf, 0x0, 0x0, 0x40, 0x0, 0x0, 0x86, 0x9, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x86, 0x9, 0x0, 0x1, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x1, 0x0, 0x86, 0x9, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x0, 0x86, 0x9, 0x0, 0x1, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x86, 0x9, 0x0, 0x1, 0x0, 0x0, 0xc0, 0xfe, 0x0, 0x10, 0x0, 0x0, 0x86, 0x9, 0x0, 0x1, 0x0, 0x0, 0xe0, 0xfe, 0x0, 0x10, 0x0, 0x0, 0x79, 0x0 })
            CreateDWordField(BUF0, 0x34, ACMM)
            CreateDWordField(BUF0, 0x4, RMA1)
            CreateDWordField(BUF0, 0x8, RSS1)
            CreateDWordField(BUF0, 0x10, RMA2)
            CreateDWordField(BUF0, 0x14, RSS2)
            CreateDWordField(BUF0, 0x1c, RMA3)
            CreateDWordField(BUF0, 0x20, RSS3)
            CreateDWordField(BUF0, 0x28, RMA4)
            CreateDWordField(BUF0, 0x2c, RSS4)
            CreateDWordField(BUF0, 0x5c, EXTM)
            Subtract(AMEM, 0x00100000, EXTM)
            If(LNot(LEqual(ROM1, Zero))) {
                Store(RMA1, RMA2)
                ShiftLeft(ROM1, 0x8, Local0)
                Store(Local0, RMA1)
                ShiftLeft(RMS1, 0x8, Local0)
                Store(Local0, RSS1)
                Store(0x8000, RSS2)
            }
            If(LNot(LEqual(ROM2, Zero))) {
                Store(RMA2, RMA3)
                ShiftLeft(ROM2, 0x8, Local0)
                Store(Local0, RMA2)
                ShiftLeft(RMS2, 0x8, Local0)
                Store(Local0, RSS2)
                Store(0xc000, RSS3)
            }
            If(LNot(LEqual(ROM3, Zero))) {
                Store(RMA3, RMA4)
                ShiftLeft(ROM3, 0x8, Local0)
                Store(Local0, RMA3)
                ShiftLeft(RMS3, 0x8, Local0)
                Store(Local0, RSS3)
                Store(0x00010000, RSS4)
            }
            Store(AMEM, ACMM)
            Return(BUF0)
        }
    }
    Device(PCI0) {
        Name(_HID, 0x030ad041)
        Name(_ADR, 0x0)
        Name(_UID, 0x1)
        Name(_BBN, 0x0)
        Name(NATA, Package(0x1) {
            0x00090000,
        })
        Method(SS3D) {
            If(LEqual(OSFL, 0x2)) {
                Return(0x2)
            }
            Else {
                Return(0x3)
            }
        }
        Method(_STA) {
            Return(0xf)
        }
        OperationRegion(LDT3, PCI_Config, 0x6c, 0x4)
        Field(LDT3, DWordAcc, NoLock, Preserve) {
            UCFG,	32
        }
        OperationRegion(S2KC, PCI_Config, 0xe4, 0x4)
        Field(S2KC, DWordAcc, NoLock, Preserve) {
            CTL0,	32
        }
        Method(_CRS) {
            Name(BUF0, Buffer(0x88) {0x88, 0xd, 0x0, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x1, 0x47, 0x1, 0xf8, 0xc, 0xf8, 0xc, 0x1, 0x8, 0x88, 0xd, 0x0, 0x1, 0xc, 0x3, 0x0, 0x0, 0x0, 0x0, 0xf7, 0xc, 0x0, 0x0, 0xf8, 0xc, 0x88, 0xd, 0x0, 0x1, 0xc, 0x3, 0x0, 0x0, 0x0, 0xd, 0xff, 0xff, 0x0, 0x0, 0x0, 0xf3, 0x87, 0x17, 0x0, 0x0, 0xc, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x0, 0xff, 0xff, 0xb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x87, 0x17, 0x0, 0x0, 0xc, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0xff, 0xff, 0xd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x87, 0x17, 0x0, 0x0, 0xc, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0xff, 0xff, 0xbf, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xff, 0x79, 0x0 })
            CreateDWordField(BUF0, 0x76, TCMM)
            CreateDWordField(BUF0, 0x82, TOMM)
            Add(AMEM, 0x00010000, TCMM)
            Subtract(0xfec00000, TCMM, TOMM)
            Return(BUF0)
        }
        Name(PICM, Package(0x14) {
            Package(0x4) {
                0x0001ffff,
                0x0,
                LSMB,
                0x0,
            },
            Package(0x4) {
                0x0001ffff,
                0x1,
                LSMB,
                0x0,
            },
            Package(0x4) {
                0x0002ffff,
                0x0,
                \_SB_.PCI0.LUBA,
                0x0,
            },
            Package(0x4) {
                0x0002ffff,
                0x1,
                \_SB_.PCI0.LUBB,
                0x0,
            },
            Package(0x4) {
                0x0002ffff,
                0x2,
                \_SB_.PCI0.LUB2,
                0x0,
            },
            Package(0x4) {
                0x0004ffff,
                0x0,
                \_SB_.PCI0.LMAC,
                0x0,
            },
            Package(0x4) {
                0x0005ffff,
                0x0,
                \_SB_.PCI0.LAPU,
                0x0,
            },
            Package(0x4) {
                0x0006ffff,
                0x0,
                \_SB_.PCI0.LACI,
                0x0,
            },
            Package(0x4) {
                0x0006ffff,
                0x1,
                \_SB_.PCI0.LMCI,
                0x0,
            },
            Package(0x4) {
                0x000dffff,
                0x0,
                \_SB_.PCI0.LFIR,
                0x0,
            },
            Package(0x4) {
                0x000cffff,
                0x0,
                \_SB_.PCI0.L3CM,
                0x0,
            },
            Package(0x4) {
                0x0009ffff,
                0x0,
                \_SB_.PCI0.LIDE,
                0x0,
            },
            Package(0x4) {
                0x0008ffff,
                0x0,
                \_SB_.PCI0.LNK1,
                0x0,
            },
            Package(0x4) {
                0x0008ffff,
                0x1,
                \_SB_.PCI0.LNK2,
                0x0,
            },
            Package(0x4) {
                0x0008ffff,
                0x2,
                \_SB_.PCI0.LNK3,
                0x0,
            },
            Package(0x4) {
                0x0008ffff,
                0x3,
                \_SB_.PCI0.LNK4,
                0x0,
            },
            Package(0x4) {
                0x001effff,
                0x0,
                \_SB_.PCI0.LNK5,
                0x0,
            },
            Package(0x4) {
                0x001effff,
                0x1,
                \_SB_.PCI0.LNK5,
                0x0,
            },
            Package(0x4) {
                0x001effff,
                0x2,
                \_SB_.PCI0.LNK5,
                0x0,
            },
            Package(0x4) {
                0x001effff,
                0x3,
                \_SB_.PCI0.LNK5,
                0x0,
            },
        })
        Name(APIC, Package(0xc) {
            Package(0x4) {
                0x0001ffff,
                0x0,
                \_SB_.PCI0.APCS,
                0x0,
            },
            Package(0x4) {
                0x0001ffff,
                0x1,
                \_SB_.PCI0.APCS,
                0x0,
            },
            Package(0x4) {
                0x0002ffff,
                0x0,
                \_SB_.PCI0.APCF,
                0x0,
            },
            Package(0x4) {
                0x0002ffff,
                0x1,
                \_SB_.PCI0.APCG,
                0x0,
            },
            Package(0x4) {
                0x0002ffff,
                0x2,
                \_SB_.PCI0.APCL,
                0x0,
            },
            Package(0x4) {
                0x0004ffff,
                0x0,
                \_SB_.PCI0.APCH,
                0x0,
            },
            Package(0x4) {
                0x0005ffff,
                0x0,
                \_SB_.PCI0.APCI,
                0x0,
            },
            Package(0x4) {
                0x0006ffff,
                0x0,
                \_SB_.PCI0.APCJ,
                0x0,
            },
            Package(0x4) {
                0x0006ffff,
                0x1,
                \_SB_.PCI0.APCK,
                0x0,
            },
            Package(0x4) {
                0x000dffff,
                0x0,
                \_SB_.PCI0.APCM,
                0x0,
            },
            Package(0x4) {
                0x000cffff,
                0x0,
                \_SB_.PCI0.AP3C,
                0x0,
            },
            Package(0x4) {
                0x0009ffff,
                0x0,
                \_SB_.PCI0.APCZ,
                0x0,
            },
        })
        Method(_PRT) {
            If(LNot(PICF)) {
                Return(PICM)
            }
            Else {
                Return(APIC)
            }
        }
        Device(HUB0) {
            Name(_ADR, 0x00080000)
            Method(_STA) {
                Return(0xf)
            }
            Name(PICM, Package(0x18) {
                Package(0x4) {
                    0x0006ffff,
                    0x0,
                    \_SB_.PCI0.LNK1,
                    0x0,
                },
                Package(0x4) {
                    0x0006ffff,
                    0x1,
                    \_SB_.PCI0.LNK2,
                    0x0,
                },
                Package(0x4) {
                    0x0006ffff,
                    0x2,
                    \_SB_.PCI0.LNK3,
                    0x0,
                },
                Package(0x4) {
                    0x0006ffff,
                    0x3,
                    \_SB_.PCI0.LNK4,
                    0x0,
                },
                Package(0x4) {
                    0x0007ffff,
                    0x0,
                    \_SB_.PCI0.LNK4,
                    0x0,
                },
                Package(0x4) {
                    0x0007ffff,
                    0x1,
                    \_SB_.PCI0.LNK1,
                    0x0,
                },
                Package(0x4) {
                    0x0007ffff,
                    0x2,
                    \_SB_.PCI0.LNK2,
                    0x0,
                },
                Package(0x4) {
                    0x0007ffff,
                    0x3,
                    \_SB_.PCI0.LNK3,
                    0x0,
                },
                Package(0x4) {
                    0x0008ffff,
                    0x0,
                    \_SB_.PCI0.LNK3,
                    0x0,
                },
                Package(0x4) {
                    0x0008ffff,
                    0x1,
                    \_SB_.PCI0.LNK4,
                    0x0,
                },
                Package(0x4) {
                    0x0008ffff,
                    0x2,
                    \_SB_.PCI0.LNK1,
                    0x0,
                },
                Package(0x4) {
                    0x0008ffff,
                    0x3,
                    \_SB_.PCI0.LNK2,
                    0x0,
                },
                Package(0x4) {
                    0x0009ffff,
                    0x0,
                    \_SB_.PCI0.LNK2,
                    0x0,
                },
                Package(0x4) {
                    0x0009ffff,
                    0x1,
                    \_SB_.PCI0.LNK3,
                    0x0,
                },
                Package(0x4) {
                    0x0009ffff,
                    0x2,
                    \_SB_.PCI0.LNK4,
                    0x0,
                },
                Package(0x4) {
                    0x0009ffff,
                    0x3,
                    \_SB_.PCI0.LNK1,
                    0x0,
                },
                Package(0x4) {
                    0x000affff,
                    0x0,
                    \_SB_.PCI0.LNK1,
                    0x0,
                },
                Package(0x4) {
                    0x000affff,
                    0x1,
                    \_SB_.PCI0.LNK2,
                    0x0,
                },
                Package(0x4) {
                    0x000affff,
                    0x2,
                    \_SB_.PCI0.LNK3,
                    0x0,
                },
                Package(0x4) {
                    0x000affff,
                    0x3,
                    \_SB_.PCI0.LNK4,
                    0x0,
                },
                Package(0x4) {
                    0x000bffff,
                    0x0,
                    \_SB_.PCI0.LNK3,
                    0x0,
                },
                Package(0x4) {
                    0x000bffff,
                    0x1,
                    \_SB_.PCI0.LNK3,
                    0x0,
                },
                Package(0x4) {
                    0x000bffff,
                    0x2,
                    \_SB_.PCI0.LNK3,
                    0x0,
                },
                Package(0x4) {
                    0x000bffff,
                    0x3,
                    \_SB_.PCI0.LNK3,
                    0x0,
                },
            })
            Name(APIC, Package(0x18) {
                Package(0x4) {
                    0x0006ffff,
                    0x0,
                    \_SB_.PCI0.APC1,
                    0x0,
                },
                Package(0x4) {
                    0x0006ffff,
                    0x1,
                    \_SB_.PCI0.APC2,
                    0x0,
                },
                Package(0x4) {
                    0x0006ffff,
                    0x2,
                    \_SB_.PCI0.APC3,
                    0x0,
                },
                Package(0x4) {
                    0x0006ffff,
                    0x3,
                    \_SB_.PCI0.APC4,
                    0x0,
                },
                Package(0x4) {
                    0x0007ffff,
                    0x0,
                    \_SB_.PCI0.APC4,
                    0x0,
                },
                Package(0x4) {
                    0x0007ffff,
                    0x1,
                    \_SB_.PCI0.APC1,
                    0x0,
                },
                Package(0x4) {
                    0x0007ffff,
                    0x2,
                    \_SB_.PCI0.APC2,
                    0x0,
                },
                Package(0x4) {
                    0x0007ffff,
                    0x3,
                    \_SB_.PCI0.APC3,
                    0x0,
                },
                Package(0x4) {
                    0x0008ffff,
                    0x0,
                    \_SB_.PCI0.APC3,
                    0x0,
                },
                Package(0x4) {
                    0x0008ffff,
                    0x1,
                    \_SB_.PCI0.APC4,
                    0x0,
                },
                Package(0x4) {
                    0x0008ffff,
                    0x2,
                    \_SB_.PCI0.APC1,
                    0x0,
                },
                Package(0x4) {
                    0x0008ffff,
                    0x3,
                    \_SB_.PCI0.APC2,
                    0x0,
                },
                Package(0x4) {
                    0x0009ffff,
                    0x0,
                    \_SB_.PCI0.APC2,
                    0x0,
                },
                Package(0x4) {
                    0x0009ffff,
                    0x1,
                    \_SB_.PCI0.APC3,
                    0x0,
                },
                Package(0x4) {
                    0x0009ffff,
                    0x2,
                    \_SB_.PCI0.APC4,
                    0x0,
                },
                Package(0x4) {
                    0x0009ffff,
                    0x3,
                    \_SB_.PCI0.APC1,
                    0x0,
                },
                Package(0x4) {
                    0x000affff,
                    0x0,
                    \_SB_.PCI0.APC1,
                    0x0,
                },
                Package(0x4) {
                    0x000affff,
                    0x1,
                    \_SB_.PCI0.APC2,
                    0x0,
                },
                Package(0x4) {
                    0x000affff,
                    0x2,
                    \_SB_.PCI0.APC3,
                    0x0,
                },
                Package(0x4) {
                    0x000affff,
                    0x3,
                    \_SB_.PCI0.APC4,
                    0x0,
                },
                Package(0x4) {
                    0x000bffff,
                    0x0,
                    \_SB_.PCI0.APC3,
                    0x0,
                },
                Package(0x4) {
                    0x000bffff,
                    0x1,
                    \_SB_.PCI0.APC3,
                    0x0,
                },
                Package(0x4) {
                    0x000bffff,
                    0x2,
                    \_SB_.PCI0.APC3,
                    0x0,
                },
                Package(0x4) {
                    0x000bffff,
                    0x3,
                    \_SB_.PCI0.APC3,
                    0x0,
                },
            })
            Method(_PRT) {
                If(LNot(PICF)) {
                    Return(PICM)
                }
                Else {
                    Return(APIC)
                }
            }
            Name(_PRW, Package(0x2) {
                0x0,
                0x5,
            })
        }
        Device(IDE0) {
            Name(_ADR, 0x00090000)
            OperationRegion(A090, PCI_Config, 0x50, 0x18)
            Field(A090, DWordAcc, NoLock, Preserve) {
                ID20,	16,
                Offset(0x8),
                IDTS,	16,
                IDTP,	16,
                ID22,	32,
                UMSS,	16,
                UMSP,	16
            }
            Name(IDEP, Buffer(0x14) { })
            Name(IDES, Buffer(0x14) { })
            Method(GTM_, 1) {
                If(LEqual(SX__, 0x1)) {
                    If(OSFL) {
                        Or(Z000, 0x1, Z000)
                    }
                }
                If(LEqual(Arg0, 0x0)) {
                    Store(IDTP, Local0)
                    Store(UMSP, Local1)
                    Store(IDEP, Local2)
                }
                Else {
                    Store(IDTS, Local0)
                    Store(UMSS, Local1)
                    Store(IDES, Local2)
                }
                CreateDWordField(Local2, 0x0, PIO0)
                CreateDWordField(Local2, 0x4, DMA0)
                CreateDWordField(Local2, 0x8, PIO1)
                CreateDWordField(Local2, 0xc, DMA1)
                CreateDWordField(Local2, 0x10, FLAG)
                Store(0x10, FLAG)
                And(Local0, 0x0f00, Local3)
                And(Local0, 0xf000, Local4)
                ShiftRight(Local3, 0x8, Local3)
                ShiftRight(Local4, 0xc, Local4)
                Add(Local3, Local4, Local3)
                Multiply(Add(Local3, 0x2, ), 0x1e, PIO0)
                If(LNot(LGreater(PIO0, 0xb4))) {
                    Or(FLAG, 0x2, FLAG)
                }
                If(And(Local1, 0x4000, )) {
                    Or(FLAG, 0x1, FLAG)
                    And(Local1, 0x0700, Local3)
                    ShiftRight(Local3, 0x8, Local3)
                    Store(U2T_(Local3), DMA0)
                }
                Else {
                    Store(PIO0, DMA0)
                }
                And(Local0, 0xf, Local3)
                And(Local0, 0xf0, Local4)
                ShiftRight(Local4, 0x4, Local4)
                Add(Local3, Local4, Local3)
                Multiply(Add(Local3, 0x2, ), 0x1e, PIO1)
                If(LNot(LGreater(PIO1, 0xb4))) {
                    Or(FLAG, 0x8, FLAG)
                }
                If(And(Local1, 0x40, )) {
                    Or(FLAG, 0x4, FLAG)
                    And(Local1, 0x7, Local3)
                    Store(U2T_(Local3), DMA1)
                }
                Else {
                    Store(PIO1, DMA1)
                }
                If(LEqual(Arg0, 0x0)) {
                    Store(Local2, IDEP)
                    Return(IDEP)
                }
                Else {
                    Store(Local2, IDES)
                    Return(IDES)
                }
            }
            Method(U2T_, 1) {
                If(LEqual(Arg0, 0x0)) {
                    Return(0x3c)
                }
                If(LEqual(Arg0, 0x1)) {
                    Return(0x5a)
                }
                If(LEqual(Arg0, 0x2)) {
                    Return(0x78)
                }
                If(LEqual(Arg0, 0x3)) {
                    Return(0x96)
                }
                If(LEqual(Arg0, 0x4)) {
                    Return(0x2d)
                }
                If(LEqual(Arg0, 0x5)) {
                    Return(0x1e)
                }
                If(LEqual(Arg0, 0x6)) {
                    Return(0x14)
                }
                Return(0xf)
            }
            Method(T2U_, 1) {
                If(LGreater(Arg0, 0x78)) {
                    Return(0x3)
                }
                If(LGreater(Arg0, 0x5a)) {
                    Return(0x2)
                }
                If(LGreater(Arg0, 0x3c)) {
                    Return(0x1)
                }
                If(LGreater(Arg0, 0x2d)) {
                    Return(0x0)
                }
                If(LGreater(Arg0, 0x1e)) {
                    Return(0x4)
                }
                If(LGreater(Arg0, 0x14)) {
                    Return(0x5)
                }
                If(LGreater(Arg0, 0xf)) {
                    Return(0x6)
                }
                Return(0x7)
            }
            Method(T2D_, 1) {
                If(LGreater(Arg0, 0x01e0)) {
                    Return(0xa8)
                }
                If(LGreater(Arg0, 0x0186)) {
                    Return(0x77)
                }
                If(LGreater(Arg0, 0xf0)) {
                    Return(0x47)
                }
                If(LGreater(Arg0, 0xb4)) {
                    Return(0x33)
                }
                If(LGreater(Arg0, 0x96)) {
                    Return(0x22)
                }
                If(LGreater(Arg0, 0x78)) {
                    Return(0x21)
                }
                Return(0x20)
            }
            Method(STM_, 4) {
                If(SX__) {
                    Store(SID0, ID20)
                    Store(SID1, IDTS)
                    Store(SID2, IDTP)
                    Store(SID3, ID22)
                    Store(SID4, UMSS)
                    Store(SID5, UMSP)
                }
                Else {
                    Store(ID20, SID0)
                    Store(IDTS, SID1)
                    Store(IDTP, SID2)
                    Store(ID22, SID3)
                    Store(UMSS, SID4)
                    Store(UMSP, SID5)
                }
                Store(0x0, SX__)
                CreateDWordField(Arg0, 0x0, PIO0)
                CreateDWordField(Arg0, 0x4, DMA0)
                CreateDWordField(Arg0, 0x8, PIO1)
                CreateDWordField(Arg0, 0xc, DMA1)
                CreateDWordField(Arg0, 0x10, FLAG)
                If(LEqual(Arg3, 0x0)) {
                    Store(SID2, Local0)
                    Store(SID5, Local1)
                }
                Else {
                    Store(SID1, Local0)
                    Store(SID4, Local1)
                }
                If(LNot(LEqual(PIO0, 0xffffffff))) {
                    And(Local0, 0xff, Local0)
                    ShiftLeft(T2D_(PIO0), 0x8, Local2)
                    Or(Local0, Local2, Local0)
                }
                If(LNot(LEqual(PIO1, 0xffffffff))) {
                    And(Local0, 0xff00, Local0)
                    Or(Local0, T2D_(PIO1), Local0)
                }
                If(And(FLAG, 0x1, )) {
                    And(Local1, 0xff, Local1)
                    ShiftLeft(T2U_(DMA0), 0x8, Local2)
                    Or(0xc000, Local2, Local2)
                    Or(Local2, Local1, Local1)
                }
                Else {
                    If(LNot(LEqual(DMA0, 0xffffffff))) {
                        And(Local0, 0xff, Local0)
                        ShiftLeft(T2D_(DMA0), 0x8, Local2)
                        Or(Local0, Local2, Local0)
                    }
                }
                If(And(FLAG, 0x4, )) {
                    And(Local1, 0xff00, Local1)
                    Or(0xc0, T2U_(DMA1), Local2)
                    Or(Local2, Local1, Local1)
                }
                Else {
                    If(LNot(LEqual(DMA1, 0xffffffff))) {
                        And(Local0, 0xff00, Local0)
                        Or(Local0, T2D_(DMA1), Local0)
                    }
                }
                If(LEqual(Arg3, 0x0)) {
                    Store(Local0, IDTP)
                    Store(Local1, UMSP)
                }
                Else {
                    Store(Local0, IDTS)
                    Store(Local1, UMSS)
                }
            }
            Method(GTF_, 2) {
                Store(Buffer(0x7) {0x3, 0x0, 0x0, 0x0, 0x0, 0xa0, 0xef }, Local0)
                CreateByteField(Local0, 0x1, MODE)
                CreateByteField(Local0, 0x5, DRIV)
                Store(Arg1, DRIV)
                If(LEqual(Arg0, 0x0)) {
                    Store(IDEP, Local1)
                }
                Else {
                    Store(IDES, Local1)
                }
                CreateDWordField(Local1, 0x0, PIO0)
                CreateDWordField(Local1, 0x4, DMA0)
                CreateDWordField(Local1, 0x8, PIO1)
                CreateDWordField(Local1, 0xc, DMA1)
                CreateDWordField(Local1, 0x10, FLGX)
                If(LEqual(Arg1, 0xa0)) {
                    Store(PIO0, Local2)
                    Store(DMA0, Local3)
                    And(FLGX, 0x1, FLGX)
                }
                Else {
                    Store(PIO1, Local2)
                    Store(DMA1, Local3)
                    And(FLGX, 0x4, FLGX)
                }
                Store(FLGX, Local1)
                If(LGreater(Local2, 0x0186)) {
                    Store(0x0, Local2)
                }
                Else {
                    If(LGreater(Local2, 0xf0)) {
                        Store(0x1, Local2)
                    }
                    Else {
                        If(LGreater(Local2, 0xb4)) {
                            Store(0x2, Local2)
                        }
                        Else {
                            If(LGreater(Local2, 0x78)) {
                                Store(0x3, Local2)
                            }
                            Else {
                                Store(0x4, Local2)
                            }
                        }
                    }
                }
                Or(0x8, Local2, MODE)
                Store(Local0, Local2)
                If(FLGX) {
                    If(LGreater(Local3, 0x5a)) {
                        Store(0x0, Local3)
                    }
                    Else {
                        If(LGreater(Local3, 0x3c)) {
                            Store(0x1, Local3)
                        }
                        Else {
                            If(LGreater(Local3, 0x2d)) {
                                Store(0x2, Local3)
                            }
                            Else {
                                If(LGreater(Local3, 0x1e)) {
                                    Store(0x3, Local3)
                                }
                                Else {
                                    If(LGreater(Local3, 0x14)) {
                                        Store(0x4, Local3)
                                    }
                                    Else {
                                        If(LGreater(Local3, 0xf)) {
                                            Store(0x5, Local3)
                                        }
                                        Else {
                                            Store(0x6, Local3)
                                        }
                                    }
                                }
                            }
                        }
                    }
                    Or(0x40, Local3, MODE)
                }
                Else {
                    If(LEqual(Local3, 0xffffffff)) {
                        Return(Local0)
                    }
                    Else {
                        If(LGreater(Local3, 0x96)) {
                            Store(0x0, Local3)
                        }
                        Else {
                            If(LGreater(Local3, 0x78)) {
                                Store(0x1, Local3)
                            }
                            Else {
                                Store(0x2, Local3)
                            }
                        }
                        Or(0x20, Local3, MODE)
                    }
                }
                Concatenate(Local0, Local2, Local1)
                Return(Local1)
            }
            Device(PRI0) {
                Name(_ADR, 0x0)
                Method(_GTM) {
                    Return(GTM_(0x0))
                }
                Method(_STM, 3) {
                    STM_(Arg0, Arg1, Arg2, 0x0)
                }
                Device(MAST) {
                    Name(_ADR, 0x0)
                    Method(_GTF) {
                        Return(GTF_(0x0, 0xa0))
                    }
                }
                Device(SLAV) {
                    Name(_ADR, 0x1)
                    Method(_GTF) {
                        Return(GTF_(0x0, 0xb0))
                    }
                }
            }
            Device(SEC0) {
                Name(_ADR, 0x1)
                Method(_GTM) {
                    Return(GTM_(0x1))
                }
                Method(_STM, 3) {
                    STM_(Arg0, Arg1, Arg2, 0x1)
                }
                Device(MAST) {
                    Name(_ADR, 0x0)
                    Method(_GTF) {
                        Return(GTF_(0x1, 0xa0))
                    }
                }
                Device(SLAV) {
                    Name(_ADR, 0x1)
                    Method(_GTF) {
                        Return(GTF_(0x1, 0xb0))
                    }
                }
            }
        }
        Device(AGPB) {
            Name(_ADR, 0x001e0000)
            Name(ONBV, 0x0)
            Name(PICM, Package(0x1) {
                Package(0x4) {
                    0xffff,
                    0x0,
                    \_SB_.PCI0.LNK5,
                    0x0,
                },
            })
            Name(APIC, Package(0x1) {
                Package(0x4) {
                    0xffff,
                    0x0,
                    \_SB_.PCI0.APC5,
                    0x0,
                },
            })
            Name(AGP0, Package(0x1) {
                Package(0x4) {
                    0xffff,
                    0x0,
                    \_SB_.PCI0.LNK4,
                    0x0,
                },
            })
            Name(AGP1, Package(0x1) {
                Package(0x4) {
                    0xffff,
                    0x0,
                    \_SB_.PCI0.APC4,
                    0x0,
                },
            })
            Method(_PRT) {
                If(LNot(PICF)) {
                    If(LEqual(ONBV, 0x1)) {
                        Return(PICM)
                    }
                    Else {
                        Return(AGP0)
                    }
                }
                Else {
                    If(LEqual(ONBV, 0x1)) {
                        Return(APIC)
                    }
                    Else {
                        Return(AGP1)
                    }
                }
            }
            Device(VGAG) {
                Name(_ADR, 0x0)
            }
        }
        Device(HUB1) {
            Name(_ADR, 0x000c0000)
            Name(PICM, Package(0x4) {
                Package(0x4) {
                    0x0001ffff,
                    0x0,
                    \_SB_.PCI0.L3CM,
                    0x0,
                },
                Package(0x4) {
                    0x0001ffff,
                    0x1,
                    \_SB_.PCI0.L3CM,
                    0x0,
                },
                Package(0x4) {
                    0x0001ffff,
                    0x2,
                    \_SB_.PCI0.L3CM,
                    0x0,
                },
                Package(0x4) {
                    0x0001ffff,
                    0x3,
                    \_SB_.PCI0.L3CM,
                    0x0,
                },
            })
            Name(APIC, Package(0x4) {
                Package(0x4) {
                    0x0001ffff,
                    0x0,
                    \_SB_.PCI0.AP3C,
                    0x0,
                },
                Package(0x4) {
                    0x0001ffff,
                    0x1,
                    \_SB_.PCI0.AP3C,
                    0x0,
                },
                Package(0x4) {
                    0x0001ffff,
                    0x2,
                    \_SB_.PCI0.AP3C,
                    0x0,
                },
                Package(0x4) {
                    0x0001ffff,
                    0x3,
                    \_SB_.PCI0.AP3C,
                    0x0,
                },
            })
            Method(_PRT) {
                If(LNot(PICF)) {
                    Return(PICM)
                }
                Else {
                    Return(APIC)
                }
            }
            Name(_PRW, Package(0x2) {
                0xa,
                0x4,
            })
        }
        Device(SMB0) {
            Name(_ADR, 0x00010001)
            OperationRegion(SMCF, PCI_Config, 0x48, 0x10)
            Field(SMCF, DWordAcc, NoLock, Preserve) {
                SMPM,	4,
                SMT1,	28,
                SMT2,	32,
                SB1_,	32,
                SB2_,	32
            }
        }
        Device(VT86) {
            Name(_ADR, 0x00010000)
            OperationRegion(PIO0, PCI_Config, 0x4, 0x20)
            Scope(\) {
                Field(\_SB_.PCI0.VT86.PIO0, ByteAcc, NoLock, Preserve) {
                    SMEN,	8,
                    Offset(0xc),
                    Offset(0xd),
                    SMIO,	8
                }
            }
            Scope(\) {
                OperationRegion(\_SB_.PCI0.VT86.P60_, PCI_Config, 0x60, 0x2)
                Field(\_SB_.PCI0.VT86.P60_, AnyAcc, NoLock, Preserve) {
                    PMBR,	16
                }
                OperationRegion(\_SB_.PCI0.VT86.P64_, PCI_Config, 0x64, 0x2)
                Field(\_SB_.PCI0.VT86.P64_, AnyAcc, NoLock, Preserve) {
                    NVSB,	16
                }
                OperationRegion(\_SB_.PCI0.VT86.P68_, PCI_Config, 0x68, 0x2)
                Field(\_SB_.PCI0.VT86.P68_, AnyAcc, NoLock, Preserve) {
                    ANLG,	16
                }
            }
            OperationRegion(PIRQ, PCI_Config, 0x7c, 0xc)
            Scope(\) {
                Field(\_SB_.PCI0.VT86.PIRQ, AnyAcc, NoLock, Preserve) {
                    INTA,	4,
                    INTB,	4,
                    INTC,	4,
                    INTD,	4,
                    INTE,	4,
                    Offset(0x4),
                    SCII,	4,
                    TCOI,	4,
                    INTF,	4,
                    INTQ,	4,
                    INTU,	4,
                    INTS,	4,
                    Offset(0x8),
                    INTG,	4,
                    INTH,	4,
                    INTJ,	4,
                    INTK,	4,
                    INTL,	4,
                    INTM,	4,
                    INTN,	4,
                    INTP,	4
                }
            }
        }
        Scope(\) {
            Method(DISD, 1) {
            }
            Method(CKIO, 2) {
            }
            Method(SLDM, 2) {
            }
        }
        Device(USB0) {
            Name(_ADR, 0x00020000)
            Method(_S1D) {
                Return(0x1)
            }
            Method(SS3D) {
                If(LEqual(OSFL, 0x2)) {
                    Return(0x2)
                }
                Else {
                    Return(0x3)
                }
            }
            Name(_PRW, Package(0x2) {
                0xd,
                0x4,
            })
        }
        Device(USB1) {
            Name(_ADR, 0x00020001)
            Method(_S1D) {
                Return(0x1)
            }
            Method(SS3D) {
                If(LEqual(OSFL, 0x2)) {
                    Return(0x2)
                }
                Else {
                    Return(0x3)
                }
            }
            Name(_PRW, Package(0x2) {
                0xc,
                0x4,
            })
        }
        Device(USB2) {
            Name(_ADR, 0x00020002)
            OperationRegion(P020, PCI_Config, 0x49, 0x1)
            Field(P020, AnyAcc, NoLock, Preserve) {
                U0WK,	1
            }
            Method(_PSW, 1) {
                If(Arg0) {
                    Store(0x1, U0WK)
                }
                Else {
                    Store(0x0, U0WK)
                }
            }
            Method(_S1D) {
                Return(0x1)
            }
            Method(SS3D) {
                Return(0x1)
            }
            Name(_PRW, Package(0x2) {
                0x5,
                0x3,
            })
        }
        Device(F139) {
            Name(_ADR, 0x000d0000)
            Method(_S1D) {
                Return(0x1)
            }
            Method(SS3D) {
                If(LEqual(OSFL, 0x2)) {
                    Return(0x2)
                }
                Else {
                    Return(0x3)
                }
            }
            Name(_PRW, Package(0x2) {
                0xf,
                0x3,
            })
        }
        Device(MMAC) {
            Name(_ADR, 0x00040000)
            Name(_PRW, Package(0x2) {
                0xb,
                0x5,
            })
        }
        Device(MAPU) {
            Name(_ADR, 0x00050000)
        }
        Device(MACI) {
            Name(_ADR, 0x00060000)
        }
        Device(MMCI) {
            Name(_ADR, 0x00060001)
            Name(_PRW, Package(0x2) {
                0x7,
                0x5,
            })
        }
        Name(BUFA, Buffer(0x6) {0x23, 0xf8, 0xdc, 0x18, 0x79, 0x0 })
        Name(BUFB, Buffer(0x6) {0x23, 0x0, 0x0, 0x18, 0x79, 0x0 })
        CreateWordField(BUFB, 0x1, IRQV)
        Method(CRS_, 1) {
            If(Arg0) {
                ShiftLeft(0x1, Arg0, IRQV)
            }
            Else {
                Store(Zero, IRQV)
            }
            Return(BUFB)
        }
        Method(SRS_, 1) {
            CreateWordField(Arg0, 0x1, IRQ0)
            FindSetRightBit(IRQ0, Local0)
            Decrement(Local0)
            Return(Local0)
        }
        Method(CRSA, 1, Serialized) {
            Store(0x0, Local0)
            If(LEqual(Arg0, 0x8)) {
                Store(0x14, Local0)
            }
            If(LEqual(Arg0, 0xd)) {
                Store(0x15, Local0)
            }
            If(LEqual(Arg0, 0x2)) {
                Store(0x16, Local0)
            }
            Name(IRZ5, Buffer(0xb) {0x89, 0x6, 0x0, 0x9, 0x1, 0x7, 0x0, 0x0, 0x0, 0x79, 0x0 })
            CreateWordField(IRZ5, 0x5, INZ5)
            Store(Local0, INZ5)
            Return(IRZ5)
        }
        Method(SRSA, 1, Serialized) {
            CreateWordField(Arg0, 0x5, INZ6)
            Store(0x8, Local0)
            If(LEqual(INZ6, 0x14)) {
                Store(0x8, Local0)
            }
            If(LEqual(INZ6, 0x15)) {
                Store(0xd, Local0)
            }
            If(LEqual(INZ6, 0x16)) {
                Store(0x2, Local0)
            }
            Return(Local0)
        }
        Device(LNK1) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x1)
            Method(_STA) {
                If(INTA) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTA)
            }
            Method(_CRS) {
                Return(CRS_(INTA))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTA)
            }
        }
        Device(LNK2) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x2)
            Method(_STA) {
                If(INTB) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTB)
            }
            Method(_CRS) {
                Return(CRS_(INTB))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTB)
            }
        }
        Device(LNK3) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x3)
            Method(_STA) {
                If(INTC) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTC)
            }
            Method(_CRS) {
                Return(CRS_(INTC))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTC)
            }
        }
        Device(LNK4) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x4)
            Method(_STA) {
                If(INTD) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTD)
            }
            Method(_CRS) {
                Return(CRS_(INTD))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTD)
            }
        }
        Device(LNK5) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x5)
            Method(_STA) {
                If(INTE) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTE)
            }
            Method(_CRS) {
                Return(CRS_(INTE))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTE)
            }
        }
        Device(LUBA) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x6)
            Method(_STA) {
                If(INTG) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTG)
            }
            Method(_CRS) {
                Return(CRS_(INTG))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTG)
            }
        }
        Device(LUBB) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x7)
            Method(_STA) {
                If(INTH) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTH)
            }
            Method(_CRS) {
                Return(CRS_(INTH))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTH)
            }
        }
        Device(LMAC) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x8)
            Method(_STA) {
                If(INTJ) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTJ)
            }
            Method(_CRS) {
                Return(CRS_(INTJ))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTJ)
            }
        }
        Device(LAPU) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x9)
            Method(_STA) {
                If(INTK) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTK)
            }
            Method(_CRS) {
                Return(CRS_(INTK))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTK)
            }
        }
        Device(LACI) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0xa)
            Method(_STA) {
                If(INTL) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTL)
            }
            Method(_CRS) {
                Return(CRS_(INTL))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTL)
            }
        }
        Device(LMCI) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0xb)
            Method(_STA) {
                If(INTM) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTM)
            }
            Method(_CRS) {
                Return(CRS_(INTM))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTM)
            }
        }
        Device(LSMB) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0xc)
            Method(_STA) {
                If(INTF) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTF)
            }
            Method(_CRS) {
                Return(CRS_(INTF))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTF)
            }
        }
        Device(LUB2) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0xd)
            Method(_STA) {
                If(INTQ) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTQ)
            }
            Method(_CRS) {
                Return(CRS_(INTQ))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTQ)
            }
        }
        Device(LFIR) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0xe)
            Method(_STA) {
                If(INTU) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTU)
            }
            Method(_CRS) {
                Return(CRS_(INTU))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTU)
            }
        }
        Device(L3CM) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0xf)
            Method(_STA) {
                If(INTS) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTS)
            }
            Method(_CRS) {
                Return(CRS_(INTS))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTS)
            }
        }
        Device(LIDE) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x10)
            Method(_STA) {
                If(INTN) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFA)
            }
            Method(_DIS) {
                Store(0x0, INTN)
                Store(0x0, INTP)
            }
            Method(_CRS) {
                Return(CRS_(INTN))
            }
            Method(_SRS, 1) {
                Store(SRS_(Arg0), INTN)
                Store(SRS_(Arg0), INTP)
            }
        }
        Name(BUF1, Buffer(0xb) {0x89, 0x6, 0x0, 0x9, 0x1, 0x10, 0x0, 0x0, 0x0, 0x79, 0x0 })
        Name(BUF2, Buffer(0xb) {0x89, 0x6, 0x0, 0x9, 0x1, 0x11, 0x0, 0x0, 0x0, 0x79, 0x0 })
        Name(BUF3, Buffer(0xb) {0x89, 0x6, 0x0, 0x9, 0x1, 0x12, 0x0, 0x0, 0x0, 0x79, 0x0 })
        Name(BUF4, Buffer(0xb) {0x89, 0x6, 0x0, 0x9, 0x1, 0x13, 0x0, 0x0, 0x0, 0x79, 0x0 })
        Name(BUFF, Buffer(0x13) {0x89, 0xe, 0x0, 0x9, 0x3, 0x14, 0x0, 0x0, 0x0, 0x15, 0x0, 0x0, 0x0, 0x16, 0x0, 0x0, 0x0, 0x79, 0x0 })
        Name(BUFI, Buffer(0xb) {0x89, 0x6, 0x0, 0x9, 0x1, 0x17, 0x0, 0x0, 0x0, 0x79, 0x0 })
        Name(IRZ1, Buffer(0xb) {0x89, 0x6, 0x0, 0x9, 0x1, 0x7, 0x0, 0x0, 0x0, 0x79, 0x0 })
        Device(APC1) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0xb)
            Method(_STA) {
                If(INTA) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUF1)
            }
            Method(_DIS) {
                Store(0x0, INTA)
            }
            Method(_CRS) {
                CreateWordField(IRZ1, 0x5, IRQ1)
                Store(0x10, IRQ1)
                Return(IRZ1)
            }
            Method(_SRS, 1) {
                Store(0x8, INTA)
            }
        }
        Device(APC2) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0xc)
            Method(_STA) {
                If(INTB) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUF2)
            }
            Method(_DIS) {
                Store(0x0, INTB)
            }
            Method(_CRS) {
                CreateWordField(IRZ1, 0x5, IRQ1)
                Store(0x11, IRQ1)
                Return(IRZ1)
            }
            Method(_SRS, 1) {
                Store(0x1, INTB)
            }
        }
        Device(APC3) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0xd)
            Method(_STA) {
                If(INTC) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUF3)
            }
            Method(_DIS) {
                Store(0x0, INTC)
            }
            Method(_CRS) {
                CreateWordField(IRZ1, 0x5, IRQ1)
                Store(0x12, IRQ1)
                Return(IRZ1)
            }
            Method(_SRS, 1) {
                Store(0x2, INTC)
            }
        }
        Device(APC4) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0xe)
            Method(_STA) {
                If(INTD) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUF4)
            }
            Method(_DIS) {
                Store(0x0, INTD)
            }
            Method(_CRS) {
                CreateWordField(IRZ1, 0x5, IRQ1)
                Store(0x13, IRQ1)
                Return(IRZ1)
            }
            Method(_SRS, 1) {
                Store(0xd, INTD)
            }
        }
        Device(APC5) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0xf)
            Method(_STA) {
                If(INTE) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUF1)
            }
            Method(_DIS) {
                Store(0x0, INTE)
            }
            Method(_CRS) {
                CreateWordField(IRZ1, 0x5, IRQ1)
                Store(0x10, IRQ1)
                Return(IRZ1)
            }
            Method(_SRS, 1) {
                Store(0x8, INTE)
            }
        }
        Device(APCF) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x10)
            Method(_STA) {
                If(INTG) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFF)
            }
            Method(_DIS) {
                Store(0x0, INTG)
            }
            Method(_CRS) {
                Return(CRSA(INTG))
            }
            Method(_SRS, 1) {
                Store(SRSA(Arg0), INTG)
            }
        }
        Device(APCG) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x11)
            Method(_STA) {
                If(INTH) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFF)
            }
            Method(_DIS) {
                Store(0x0, INTH)
            }
            Method(_CRS) {
                Return(CRSA(INTH))
            }
            Method(_SRS, 1) {
                Store(SRSA(Arg0), INTH)
            }
        }
        Device(APCH) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x12)
            Method(_STA) {
                If(INTJ) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFF)
            }
            Method(_DIS) {
                Store(0x0, INTJ)
            }
            Method(_CRS) {
                Return(CRSA(INTJ))
            }
            Method(_SRS, 1) {
                Store(SRSA(Arg0), INTJ)
            }
        }
        Device(APCI) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x1a)
            Method(_STA) {
                If(INTK) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFF)
            }
            Method(_DIS) {
                Store(0x0, INTK)
            }
            Method(_CRS) {
                Return(CRSA(INTK))
            }
            Method(_SRS, 1) {
                Store(SRSA(Arg0), INTK)
            }
        }
        Device(APCJ) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x1b)
            Method(_STA) {
                If(INTL) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFF)
            }
            Method(_DIS) {
                Store(0x0, INTL)
            }
            Method(_CRS) {
                Return(CRSA(INTL))
            }
            Method(_SRS, 1) {
                Store(SRSA(Arg0), INTL)
            }
        }
        Device(APCK) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x1c)
            Method(_STA) {
                If(INTM) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFF)
            }
            Method(_DIS) {
                Store(0x0, INTM)
            }
            Method(_CRS) {
                Return(CRSA(INTM))
            }
            Method(_SRS, 1) {
                Store(SRSA(Arg0), INTM)
            }
        }
        Device(APCS) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x1d)
            Method(_STA) {
                If(INTF) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFI)
            }
            Method(_DIS) {
                Store(0x0, INTF)
            }
            Method(_CRS) {
                CreateWordField(IRZ1, 0x5, IRQ1)
                Store(0x17, IRQ1)
                Return(IRZ1)
            }
            Method(_SRS, 1) {
                Store(0x2, INTF)
            }
        }
        Device(APCL) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x1e)
            Method(_STA) {
                If(INTQ) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFF)
            }
            Method(_DIS) {
                Store(0x0, INTQ)
            }
            Method(_CRS) {
                Return(CRSA(INTQ))
            }
            Method(_SRS, 1) {
                Store(SRSA(Arg0), INTQ)
            }
        }
        Device(APCM) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x1f)
            Method(_STA) {
                If(INTU) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFF)
            }
            Method(_DIS) {
                Store(0x0, INTU)
            }
            Method(_CRS) {
                Return(CRSA(INTU))
            }
            Method(_SRS, 1) {
                Store(SRSA(Arg0), INTU)
            }
        }
        Device(AP3C) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x20)
            Method(_STA) {
                If(INTS) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFF)
            }
            Method(_DIS) {
                Store(0x0, INTS)
            }
            Method(_CRS) {
                Return(CRSA(INTS))
            }
            Method(_SRS, 1) {
                Store(SRSA(Arg0), INTS)
            }
        }
        Device(APCZ) {
            Name(_HID, 0x0f0cd041)
            Name(_UID, 0x21)
            Method(_STA) {
                If(INTN) {
                    Return(0xb)
                }
                Else {
                    Return(0x9)
                }
            }
            Method(_PRS) {
                Return(BUFF)
            }
            Method(_DIS) {
                Store(0x0, INTN)
                Store(0x0, INTP)
            }
            Method(_CRS) {
                Return(CRSA(INTN))
            }
            Method(_SRS, 1) {
                Store(SRSA(Arg0), INTN)
                Store(SRSA(Arg0), INTP)
            }
        }
        Scope(\) {
            OperationRegion(\SCPP, SystemIO, 0x442e, 0x1)
            Field(\SCPP, ByteAcc, NoLock, Preserve) {
                SMIP,	8
            }
        }
        Method(\_SB_.PCI0._INI) {
            If(STRC(\_OS_, "Microsoft Windows")) {
                Store(0x56, SMIP)
            }
            Else {
                If(STRC(\_OS_, "Microsoft Windows NT")) {
                    If(CondRefOf(_OSI, Local0)) {
                        If(\_OSI("Windows 2001")) {
                            Store(0x59, SMIP)
                            Store(0x0, OSFL)
                            Store(0x3, OSFX)
                        }
                    }
                    Else {
                        Store(0x58, SMIP)
                        Store(0x0, OSFL)
                    }
                }
                Else {
                    Store(0x57, SMIP)
                    Store(0x2, OSFL)
                }
            }
        }
        Scope(\) {
            Method(OSTP) {
                If(LEqual(OSFL, 0x1)) {
                    Store(0x56, SMIP)
                }
                If(LEqual(OSFL, 0x2)) {
                    Store(0x57, SMIP)
                }
                If(LEqual(OSFL, 0x0)) {
                    Store(0x58, SMIP)
                }
                If(LEqual(OSFX, 0x3)) {
                    Store(0x59, SMIP)
                }
            }
        }
        Device(SYSR) {
            Name(_HID, 0x020cd041)
            Name(_UID, 0x1)
            Name(_CRS, Buffer(0x52) {0x47, 0x1, 0x10, 0x0, 0x10, 0x0, 0x1, 0x10, 0x47, 0x1, 0x22, 0x0, 0x22, 0x0, 0x1, 0x1e, 0x47, 0x1, 0x44, 0x0, 0x44, 0x0, 0x1, 0x1c, 0x47, 0x1, 0x62, 0x0, 0x62, 0x0, 0x1, 0x2, 0x47, 0x1, 0x65, 0x0, 0x65, 0x0, 0x1, 0xb, 0x47, 0x1, 0x74, 0x0, 0x74, 0x0, 0x1, 0xc, 0x47, 0x1, 0x91, 0x0, 0x91, 0x0, 0x1, 0x3, 0x47, 0x1, 0xa2, 0x0, 0xa2, 0x0, 0x1, 0x1e, 0x47, 0x1, 0xe0, 0x0, 0xe0, 0x0, 0x1, 0x10, 0x47, 0x1, 0xd0, 0x4, 0xd0, 0x4, 0x1, 0x2, 0x79, 0x0 })
        }
        Device(PIC_) {
            Name(_HID, 0xd041)
            Name(_CRS, Buffer(0x15) {0x47, 0x1, 0x20, 0x0, 0x20, 0x0, 0x1, 0x2, 0x47, 0x1, 0xa0, 0x0, 0xa0, 0x0, 0x1, 0x2, 0x22, 0x4, 0x0, 0x79, 0x0 })
        }
        Device(DMA1) {
            Name(_HID, 0x0002d041)
            Name(_CRS, Buffer(0x25) {0x2a, 0x10, 0x4, 0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x10, 0x47, 0x1, 0x80, 0x0, 0x80, 0x0, 0x1, 0x11, 0x47, 0x1, 0x94, 0x0, 0x94, 0x0, 0x1, 0xc, 0x47, 0x1, 0xc0, 0x0, 0xc0, 0x0, 0x1, 0x20, 0x79, 0x0 })
        }
        Device(TMR_) {
            Name(_HID, 0x0001d041)
            Name(_CRS, Buffer(0xd) {0x47, 0x1, 0x40, 0x0, 0x40, 0x0, 0x1, 0x4, 0x22, 0x1, 0x0, 0x79, 0x0 })
        }
        Device(RTC_) {
            Name(_HID, 0x000bd041)
            Name(_CRS, Buffer(0xd) {0x47, 0x1, 0x70, 0x0, 0x70, 0x0, 0x4, 0x4, 0x22, 0x0, 0x1, 0x79, 0x0 })
        }
        Device(SPKR) {
            Name(_HID, 0x0008d041)
            Name(_CRS, Buffer(0xa) {0x47, 0x1, 0x61, 0x0, 0x61, 0x0, 0x1, 0x1, 0x79, 0x0 })
        }
        Device(COPR) {
            Name(_HID, 0x040cd041)
            Name(_CRS, Buffer(0xd) {0x47, 0x1, 0xf0, 0x0, 0xf0, 0x0, 0x1, 0x10, 0x22, 0x0, 0x20, 0x79, 0x0 })
        }
        Scope(\) {
            OperationRegion(WIN1, SystemIO, 0x2e, 0x2)
            Field(WIN1, ByteAcc, NoLock, Preserve) {
                INDP,	8,
                DATP,	8
            }
            IndexField(INDP, DATP, ByteAcc, NoLock, Preserve) {
                Offset(0x2),
                CFG_,	8,
                Offset(0x7),
                LDN_,	8,
                Offset(0x20),
                IDHI,	8,
                IDLO,	8,
                POWC,	8,
                Offset(0x30),
                ACTR,	8,
                Offset(0x60),
                IOAH,	8,
                IOAL,	8,
                IO2H,	8,
                IO2L,	8,
                Offset(0x70),
                INTR,	8,
                Offset(0x72),
                INT1,	8,
                Offset(0x74),
                DMCH,	8,
                Offset(0xf0),
                OPT1,	8,
                OPT2,	8,
                OPT3,	8
            }
            Method(ENFG) {
                Store(0x87, INDP)
                Store(0x87, INDP)
            }
            Method(EXFG) {
                Store(0x2, CFG_)
            }
            Method(GSRG, 1) {
                Store(Arg0, INDP)
                Return(DATP)
            }
            Method(SSRG, 2) {
                Store(Arg0, INDP)
                Store(Arg1, DATP)
            }
        }
        Device(FDC0) {
            Name(_HID, 0x0007d041)
            Method(_STA) {
                ENFG()
                Store(Zero, LDN_)
                If(ACTR) {
                    EXFG()
                    Return(0xf)
                }
                Else {
                    If(LOr(IOAH, IOAL)) {
                        EXFG()
                        Return(0xd)
                    }
                    Else {
                        EXFG()
                        Return(0x0)
                    }
                }
            }
            Method(_DIS) {
                ENFG()
                Store(0x0, LDN_)
                Store(Zero, ACTR)
                SLDM(DMCH, 0x4)
                EXFG()
                DISD(0x3)
            }
            Method(_CRS) {
                Name(BUF0, Buffer(0x18) {0x47, 0x1, 0xf0, 0x3, 0xf0, 0x3, 0x1, 0x6, 0x47, 0x1, 0xf7, 0x3, 0xf7, 0x3, 0x1, 0x1, 0x22, 0x40, 0x0, 0x2a, 0x4, 0x0, 0x79, 0x0 })
                CreateByteField(BUF0, 0x2, IOLO)
                CreateByteField(BUF0, 0x3, IOHI)
                CreateByteField(BUF0, 0x4, IORL)
                CreateByteField(BUF0, 0x5, IORH)
                ENFG()
                EXFG()
                Return(BUF0)
            }
            Name(_PRS, Buffer(0x1a) {0x30, 0x47, 0x1, 0xf0, 0x3, 0xf0, 0x3, 0x1, 0x6, 0x47, 0x1, 0xf7, 0x3, 0xf7, 0x3, 0x1, 0x1, 0x22, 0x40, 0x0, 0x2a, 0x4, 0x0, 0x38, 0x79, 0x0 })
            Method(_SRS, 1) {
                CreateByteField(Arg0, 0x2, IOLO)
                CreateByteField(Arg0, 0x3, IOHI)
                CreateWordField(Arg0, 0x2, IOAD)
                CreateWordField(Arg0, 0x19, IRQW)
                CreateByteField(Arg0, 0x1c, DMAV)
                ENFG()
                Store(Zero, LDN_)
                Store(One, ACTR)
                SLDM(DMCH, DMCH)
                CKIO(IOAD, 0x3)
                EXFG()
            }
        }
        Device(UAR1) {
            Name(_HID, 0x0105d041)
            Name(_UID, 0x1)
            Method(_STA) {
                ENFG()
                Store(0x1, LDN_)
                If(ACTR) {
                    EXFG()
                    Return(0xf)
                }
                Else {
                    If(LOr(IOAH, IOAL)) {
                        EXFG()
                        Return(0xd)
                    }
                    Else {
                        EXFG()
                        Return(0x0)
                    }
                }
                EXFG()
            }
            Method(_DIS) {
                ENFG()
                Store(0x1, LDN_)
                Store(Zero, ACTR)
                EXFG()
                DISD(0x0)
            }
            Method(_CRS) {
                Name(BUF1, Buffer(0xd) {0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x8, 0x22, 0x0, 0x0, 0x79, 0x0 })
                CreateByteField(BUF1, 0x2, IOLO)
                CreateByteField(BUF1, 0x3, IOHI)
                CreateByteField(BUF1, 0x4, IORL)
                CreateByteField(BUF1, 0x5, IORH)
                CreateWordField(BUF1, 0x9, IRQW)
                ENFG()
                Store(0x1, LDN_)
                Store(IOAL, IOLO)
                Store(IOAL, IORL)
                Store(IOAH, IOHI)
                Store(IOAH, IORH)
                Store(One, Local0)
                ShiftLeft(Local0, INTR, IRQW)
                EXFG()
                Return(BUF1)
            }
            Name(_PRS, Buffer(0x33) {0x30, 0x47, 0x1, 0xf8, 0x3, 0xf8, 0x3, 0x1, 0x8, 0x22, 0xb8, 0x1e, 0x30, 0x47, 0x1, 0xf8, 0x2, 0xf8, 0x2, 0x1, 0x8, 0x22, 0xb8, 0x1e, 0x30, 0x47, 0x1, 0xe8, 0x3, 0xe8, 0x3, 0x1, 0x8, 0x22, 0xb8, 0x1e, 0x30, 0x47, 0x1, 0xe8, 0x2, 0xe8, 0x2, 0x1, 0x8, 0x22, 0xb8, 0x1e, 0x38, 0x79, 0x0 })
            Method(_SRS, 1) {
                CreateByteField(Arg0, 0x2, IOLO)
                CreateByteField(Arg0, 0x3, IOHI)
                CreateWordField(Arg0, 0x2, IOAD)
                CreateWordField(Arg0, 0x9, IRQW)
                ENFG()
                Store(0x1, LDN_)
                Store(One, ACTR)
                Store(IOLO, IOAL)
                Store(IOHI, IOAH)
                FindSetRightBit(IRQW, Local0)
                Subtract(Local0, 0x1, INTR)
                EXFG()
                CKIO(IOAD, 0x0)
            }
        }
        Device(UAR2) {
            Method(_HID) {
                ENFG()
                Store(0x2, LDN_)
                And(OPT2, 0x7, Local0)
                If(LEqual(Local0, 0x4)) {
                    Return(0x05878526)
                }
                Else {
                    Return(0x0105d041)
                }
                EXFG()
            }
            Name(_UID, 0x2)
            Method(_STA) {
                ENFG()
                Store(0x2, LDN_)
                And(OPT2, 0x7, Local0)
                If(LNot(LEqual(Local0, 0x1))) {
                    If(ACTR) {
                        EXFG()
                        Return(0xf)
                    }
                    Else {
                        If(LOr(IOAH, IOAL)) {
                            EXFG()
                            Return(0xd)
                        }
                        Else {
                            EXFG()
                            Return(0x0)
                        }
                    }
                }
                Else {
                    EXFG()
                    Return(0x0)
                }
            }
            Method(_DIS) {
                ENFG()
                Store(0x2, LDN_)
                Store(Zero, ACTR)
                EXFG()
                DISD(0x1)
            }
            Method(_CRS) {
                Name(BUF2, Buffer(0xd) {0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x8, 0x22, 0x10, 0x0, 0x79, 0x0 })
                CreateByteField(BUF2, 0x2, IOLO)
                CreateByteField(BUF2, 0x3, IOHI)
                CreateByteField(BUF2, 0x4, IORL)
                CreateByteField(BUF2, 0x5, IORH)
                CreateWordField(BUF2, 0x9, IRQW)
                ENFG()
                Store(0x2, LDN_)
                Store(IOAL, IOLO)
                Store(IOAL, IORL)
                Store(IOAH, IOHI)
                Store(IOAH, IORH)
                Store(One, Local0)
                ShiftLeft(Local0, INTR, IRQW)
                EXFG()
                Return(BUF2)
            }
            Name(_PRS, Buffer(0x33) {0x30, 0x47, 0x1, 0xf8, 0x3, 0xf8, 0x3, 0x1, 0x8, 0x22, 0xb8, 0x1e, 0x30, 0x47, 0x1, 0xf8, 0x2, 0xf8, 0x2, 0x1, 0x8, 0x22, 0xb8, 0x1e, 0x30, 0x47, 0x1, 0xe8, 0x3, 0xe8, 0x3, 0x1, 0x8, 0x22, 0xb8, 0x1e, 0x30, 0x47, 0x1, 0xe8, 0x2, 0xe8, 0x2, 0x1, 0x8, 0x22, 0xb8, 0x1e, 0x38, 0x79, 0x0 })
            Method(_SRS, 1) {
                CreateByteField(Arg0, 0x2, IOLO)
                CreateByteField(Arg0, 0x3, IOHI)
                CreateWordField(Arg0, 0x2, IOAD)
                CreateWordField(Arg0, 0x9, IRQW)
                ENFG()
                Store(0x2, LDN_)
                Store(One, ACTR)
                Store(IOLO, IOAL)
                Store(IOHI, IOAH)
                FindSetRightBit(IRQW, Local0)
                Subtract(Local0, 0x1, INTR)
                EXFG()
                CKIO(IOAD, 0x1)
            }
        }
        Device(IRDA) {
            Name(_HID, 0x1005d041)
            Method(_STA) {
                ENFG()
                Store(0x2, LDN_)
                And(OPT2, 0x7, Local0)
                If(LEqual(Local0, 0x1)) {
                    If(ACTR) {
                        EXFG()
                        Return(0xf)
                    }
                    Else {
                        If(LOr(IOAH, IOAL)) {
                            EXFG()
                            Return(0xd)
                        }
                        Else {
                            EXFG()
                            Return(0x0)
                        }
                    }
                }
                Else {
                    EXFG()
                    Return(0x0)
                }
            }
            Method(_DIS) {
                If(LEqual(DISE, 0x1)) {
                    ENFG()
                    Store(0x2, LDN_)
                    Store(Zero, ACTR)
                    EXFG()
                    DISD(0x1)
                }
            /*    Store(Local0, Local0) */
            }
            Method(_CRS) {
                Name(BUF4, Buffer(0xd) {0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x8, 0x22, 0x0, 0x0, 0x79, 0x0 })
                CreateByteField(BUF4, 0x2, IOLO)
                CreateByteField(BUF4, 0x3, IOHI)
                CreateByteField(BUF4, 0x4, IORL)
                CreateByteField(BUF4, 0x5, IORH)
                CreateWordField(BUF4, 0x9, IRQW)
                ENFG()
                Store(0x2, LDN_)
                Store(IOAL, IOLO)
                Store(IOAL, IORL)
                Store(IOAH, IOHI)
                Store(IOAH, IORH)
                ShiftLeft(0x1, INTR, IRQW)
                EXFG()
                Return(BUF4)
            }
            Name(_PRS, Buffer(0x33) {0x30, 0x47, 0x1, 0xf8, 0x3, 0xf8, 0x3, 0x1, 0x8, 0x22, 0xb8, 0x1e, 0x30, 0x47, 0x1, 0xf8, 0x2, 0xf8, 0x2, 0x1, 0x8, 0x22, 0xb8, 0x1e, 0x30, 0x47, 0x1, 0xe8, 0x3, 0xe8, 0x3, 0x1, 0x8, 0x22, 0xb8, 0x1e, 0x30, 0x47, 0x1, 0xe8, 0x2, 0xe8, 0x2, 0x1, 0x8, 0x22, 0xb8, 0x1e, 0x38, 0x79, 0x0 })
            Method(_SRS, 1) {
                CreateByteField(Arg0, 0x2, IOLO)
                CreateByteField(Arg0, 0x3, IOHI)
                CreateWordField(Arg0, 0x2, IOAD)
                CreateWordField(Arg0, 0x9, IRQW)
                ENFG()
                Store(0x2, LDN_)
                Store(One, ACTR)
                Store(IOLO, IOAL)
                Store(IOHI, IOAH)
                FindSetRightBit(IRQW, Local0)
                Subtract(Local0, 0x1, INTR)
                EXFG()
                CKIO(IOAD, 0x1)
            }
        }
        Device(LPT1) {
            Name(_HID, 0x0004d041)
            Method(_STA) {
                ENFG()
                Store(0x3, LDN_)
                And(OPT1, 0x2, Local0)
                If(LNot(LEqual(Local0, 0x2))) {
                    If(ACTR) {
                        EXFG()
                        Return(0xf)
                    }
                    Else {
                        If(LOr(IOAH, IOAL)) {
                            EXFG()
                            Return(0xd)
                        }
                        Else {
                            EXFG()
                            Return(0x0)
                        }
                    }
                }
                Else {
                    EXFG()
                    Return(0x0)
                }
            }
            Method(_DIS) {
                ENFG()
                Store(0x3, LDN_)
                Store(Zero, ACTR)
                EXFG()
                DISD(0x2)
            }
            Method(_CRS) {
                Name(BUF5, Buffer(0xd) {0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x8, 0x22, 0x0, 0x0, 0x79, 0x0 })
                CreateByteField(BUF5, 0x2, IOLO)
                CreateByteField(BUF5, 0x3, IOHI)
                CreateByteField(BUF5, 0x4, IORL)
                CreateByteField(BUF5, 0x5, IORH)
                CreateByteField(BUF5, 0x7, IOLE)
                CreateWordField(BUF5, 0x9, IRQW)
                ENFG()
                Store(0x3, LDN_)
                Store(IOAL, IOLO)
                Store(IOLO, IORL)
                Store(IOAH, IOHI)
                Store(IOHI, IORH)
                If(LEqual(IOLO, 0xbc)) {
                    Store(0x4, IOLE)
                }
                Else {
                    Store(0x8, IOLE)
                }
                Store(One, Local0)
                Store(INTR, Local5)
                ShiftLeft(Local0, Local5, IRQW)
                EXFG()
                Return(BUF5)
            }
            Name(_PRS, Buffer(0x27) {0x30, 0x47, 0x1, 0x78, 0x3, 0x78, 0x3, 0x1, 0x8, 0x22, 0xb8, 0x1e, 0x30, 0x47, 0x1, 0x78, 0x2, 0x78, 0x2, 0x1, 0x8, 0x22, 0xb8, 0x1e, 0x30, 0x47, 0x1, 0xbc, 0x3, 0xbc, 0x3, 0x1, 0x4, 0x22, 0xb8, 0x1e, 0x38, 0x79, 0x0 })
            Method(_SRS, 1) {
                CreateByteField(Arg0, 0x2, IOLO)
                CreateByteField(Arg0, 0x3, IOHI)
                CreateWordField(Arg0, 0x2, IOAD)
                CreateByteField(Arg0, 0x4, IORL)
                CreateByteField(Arg0, 0x5, IORH)
                CreateWordField(Arg0, 0x9, IRQW)
                ENFG()
                Store(0x3, LDN_)
                Store(One, ACTR)
                Store(IOLO, IOAL)
                Store(IOHI, IOAH)
                FindSetLeftBit(IRQW, Local0)
                Subtract(Local0, 0x1, Local0)
                Store(Local0, INTR)
                EXFG()
                CKIO(IOAD, 0x2)
            }
        }
        Device(ECP1) {
            Name(_HID, 0x0104d041)
            Method(_STA) {
                ENFG()
                Store(0x3, LDN_)
                And(OPT1, 0x2, Local0)
                If(LEqual(Local0, 0x2)) {
                    If(ACTR) {
                        EXFG()
                        Return(0xf)
                    }
                    Else {
                        If(LOr(IOAH, IOAL)) {
                            EXFG()
                            Return(0xd)
                        }
                        Else {
                            EXFG()
                            Return(0x0)
                        }
                    }
                }
                Else {
                    EXFG()
                    Return(0x0)
                }
            }
            Method(_DIS) {
                ENFG()
                Store(0x3, LDN_)
                Store(Zero, ACTR)
                SLDM(DMCH, 0x4)
                EXFG()
                DISD(0x2)
            }
            Method(_CRS) {
                Name(BUF6, Buffer(0x18) {0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x22, 0x0, 0x0, 0x2a, 0x0, 0x0, 0x79, 0x0 })
                CreateByteField(BUF6, 0x2, IOLO)
                CreateByteField(BUF6, 0x3, IOHI)
                CreateByteField(BUF6, 0x4, IORL)
                CreateByteField(BUF6, 0x5, IORH)
                CreateByteField(BUF6, 0x7, IOLE)
                CreateByteField(BUF6, 0xa, IOEL)
                CreateByteField(BUF6, 0xb, IOEH)
                CreateByteField(BUF6, 0xc, IOML)
                CreateByteField(BUF6, 0xd, IOMH)
                CreateWordField(BUF6, 0x11, IRQW)
                CreateByteField(BUF6, 0x14, DMAC)
                ENFG()
                Store(0x3, LDN_)
                Store(IOAL, Local2)
                Store(Local2, IOLO)
                Store(IOAH, Local3)
                Store(Local3, IOHI)
                Or(Local3, 0x4, Local3)
                Store(Local3, IOEH)
                Store(Local3, IOMH)
                Store(IOLO, IORL)
                Store(IOLO, IOEL)
                Store(IOLO, IOML)
                Store(IOHI, IORH)
                If(LEqual(IOLO, 0xbc)) {
                    Store(0x4, IOLE)
                }
                Else {
                    Store(0x8, IOLE)
                }
                Store(One, Local0)
                Store(INTR, Local5)
                ShiftLeft(Local0, Local5, IRQW)
                Store(One, Local0)
                Store(DMCH, Local5)
                ShiftLeft(Local0, Local5, DMAC)
                EXFG()
                Return(BUF6)
            }
            Name(_PRS, Buffer(0x48) {0x30, 0x47, 0x1, 0x78, 0x3, 0x78, 0x3, 0x0, 0x8, 0x47, 0x1, 0x78, 0x7, 0x78, 0x7, 0x0, 0x4, 0x22, 0xb8, 0x1e, 0x2a, 0xb, 0x0, 0x30, 0x47, 0x1, 0x78, 0x2, 0x78, 0x2, 0x0, 0x8, 0x47, 0x1, 0x78, 0x6, 0x78, 0x6, 0x0, 0x4, 0x22, 0xb8, 0x1e, 0x2a, 0xb, 0x0, 0x30, 0x47, 0x1, 0xbc, 0x3, 0xbc, 0x3, 0x0, 0x4, 0x47, 0x1, 0xbc, 0x7, 0xbc, 0x7, 0x0, 0x4, 0x22, 0xb8, 0x1e, 0x2a, 0xb, 0x0, 0x38, 0x79, 0x0 })
            Method(_SRS, 1) {
                CreateByteField(Arg0, 0x2, IOLO)
                CreateByteField(Arg0, 0x3, IOHI)
                CreateWordField(Arg0, 0x2, IOAD)
                CreateWordField(Arg0, 0x11, IRQW)
                CreateByteField(Arg0, 0x14, DMAC)
                ENFG()
                Store(0x3, LDN_)
                Store(One, ACTR)
                Store(IOLO, IOAL)
                Store(IOHI, IOAH)
                FindSetLeftBit(IRQW, Local0)
                Subtract(Local0, 0x1, Local0)
                Store(Local0, INTR)
                FindSetLeftBit(DMAC, Local1)
                Store(DMCH, Local0)
                Subtract(Local1, 0x1, DMCH)
                SLDM(Local0, DMCH)
                EXFG()
                CKIO(IOAD, 0x2)
            }
        }
        OperationRegion(KBCT, SystemIO, 0x60, 0x5)
        Field(KBCT, ByteAcc, NoLock, Preserve) {
            P060,	8,
            Offset(0x4),
            P064,	8
        }
        Device(PS2M) {
            Name(_HID, 0x130fd041)
            Method(_STA) {
                If(LEqual(PS2F, 0x0)) {
                    Return(0xf)
                }
                Else {
                    Return(0x0)
                }
            }
            Method(_CRS) {
                Name(BUF1, Buffer(0x5) {0x22, 0x0, 0x10, 0x79, 0x0 })
                Name(BUF2, Buffer(0x15) {0x47, 0x1, 0x60, 0x0, 0x60, 0x0, 0x1, 0x1, 0x47, 0x1, 0x64, 0x0, 0x64, 0x0, 0x1, 0x1, 0x22, 0x0, 0x10, 0x79, 0x0 })
                If(LEqual(KBDI, 0x1)) {
                    If(LEqual(OSFL, 0x2)) {
                        Return(BUF1)
                    }
                    If(LEqual(OSFL, 0x1)) {
                        Return(BUF1)
                    }
                    Else {
                        Return(BUF2)
                    }
                }
                Else {
                    Return(BUF1)
                }
            }
        }
        Device(PS2K) {
            Name(_HID, 0x0303d041)
            Name(_CID, 0x0b03d041)
            Method(_STA) {
                If(LEqual(KBDI, 0x1)) {
                    Return(0x0)
                }
                Else {
                    Return(0xf)
                }
            }
            Name(_CRS, Buffer(0x15) {0x47, 0x1, 0x60, 0x0, 0x60, 0x0, 0x1, 0x1, 0x47, 0x1, 0x64, 0x0, 0x64, 0x0, 0x1, 0x1, 0x22, 0x2, 0x0, 0x79, 0x0 })
        }
        Device(MIDI) {
            Name(_HID, 0x06b0d041)
            Method(_STA) {
                ENFG()
                Store(0xa, LDN_)
                If(ACTR) {
                    EXFG()
                    Return(0xf)
                }
                Else {
                    If(LOr(IOAH, IOAL)) {
                        EXFG()
                        Return(0xd)
                    }
                    Else {
                        EXFG()
                        Return(0x0)
                    }
                }
                EXFG()
            }
            Method(_DIS) {
                ENFG()
                Store(0xa, LDN_)
                Store(Zero, ACTR)
                EXFG()
                DISD(0x5)
            }
            Method(_CRS) {
                Name(BUF1, Buffer(0xd) {0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x22, 0x0, 0x0, 0x79, 0x0 })
                CreateByteField(BUF1, 0x2, IOLO)
                CreateByteField(BUF1, 0x3, IOHI)
                CreateByteField(BUF1, 0x4, IORL)
                CreateByteField(BUF1, 0x5, IORH)
                CreateWordField(BUF1, 0x9, IRQW)
                ENFG()
                Store(0xa, LDN_)
                Store(IOAL, IOLO)
                Store(IOAL, IORL)
                Store(IOAH, IOHI)
                Store(IOAH, IORH)
                Store(One, Local0)
                ShiftLeft(Local0, INTR, IRQW)
                EXFG()
                Return(BUF1)
            }
            Name(_PRS, Buffer(0x1b) {0x30, 0x47, 0x1, 0x30, 0x3, 0x30, 0x3, 0x1, 0x2, 0x22, 0xb8, 0x1e, 0x30, 0x47, 0x1, 0x0, 0x3, 0x0, 0x3, 0x1, 0x2, 0x22, 0xb8, 0x1e, 0x38, 0x79, 0x0 })
            Method(_SRS, 1) {
                CreateByteField(Arg0, 0x2, IOLO)
                CreateByteField(Arg0, 0x3, IOHI)
                CreateWordField(Arg0, 0x2, IOAD)
                CreateWordField(Arg0, 0x9, IRQW)
                ENFG()
                Store(0xa, LDN_)
                Store(One, ACTR)
                Store(IOLO, IOAL)
                Store(IOHI, IOAH)
                FindSetRightBit(IRQW, Local0)
                Subtract(Local0, 0x1, INTR)
                EXFG()
                CKIO(IOAD, 0x5)
            }
        }
        Device(GAME) {
            Name(_HID, 0x2fb0d041)
            Method(_STA) {
                ENFG()
                Store(0x8, LDN_)
                If(ACTR) {
                    EXFG()
                    Return(0xf)
                }
                Else {
                    If(LOr(IOAH, IOAL)) {
                        EXFG()
                        Return(0xd)
                    }
                    Else {
                        EXFG()
                        Return(0x0)
                    }
                }
                EXFG()
            }
            Method(_DIS) {
                ENFG()
                Store(0x8, LDN_)
                Store(Zero, ACTR)
                EXFG()
                DISD(0x4)
            }
            Method(_CRS) {
                Name(BUF1, Buffer(0xa) {0x47, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x79, 0x0 })
                CreateByteField(BUF1, 0x2, IOLO)
                CreateByteField(BUF1, 0x3, IOHI)
                CreateByteField(BUF1, 0x4, IORL)
                CreateByteField(BUF1, 0x5, IORH)
                ENFG()
                Store(0x8, LDN_)
                Store(IOAL, IOLO)
                Store(IOAL, IORL)
                Store(IOAH, IOHI)
                Store(IOAH, IORH)
                EXFG()
                Return(BUF1)
            }
            Name(_PRS, Buffer(0x15) {0x30, 0x47, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x30, 0x47, 0x1, 0x9, 0x2, 0x9, 0x2, 0x1, 0x1, 0x38, 0x79, 0x0 })
            Method(_SRS, 1) {
                CreateByteField(Arg0, 0x2, IOLO)
                CreateByteField(Arg0, 0x3, IOHI)
                CreateWordField(Arg0, 0x2, IOAD)
                ENFG()
                Store(0x8, LDN_)
                Store(One, ACTR)
                Store(IOLO, IOAL)
                Store(IOHI, IOAH)
                EXFG()
                CKIO(IOAD, 0x4)
            }
        }
        Method(\_SB_.PCI0.UAR1._PRW) {
            Return(Package(0x2) {
                0x3,
                0x5,
            })
        }
    }
}

}
/*
APIC: Length=110, Revision=1, Checksum=117,
	OEMID=Nvidia, OEM Table ID=AWRDACPI, OEM Revision=0x42302e31,
	Creator ID=AWRD, Creator Revision=0x0
 */
